<?php
/**
 * Admin Authentication Check
 * Must be included in all admin pages
 */

// Start session if not already started
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Check if user is logged in (before any output)
if (!isset($_SESSION['admin_id'])) {
    header('Location: login.php');
    exit;
}

// Verify user is admin
require_once __DIR__ . '/../../database.php';
$db = getDB();

$stmt = $db->prepare("SELECT id, name, email, role FROM users WHERE id = ? AND role = 'admin'");
$stmt->execute([$_SESSION['admin_id']]);
$admin = $stmt->fetch();

if (!$admin) {
    session_destroy();
    header('Location: login.php');
    exit;
}

// Store admin data in global
$GLOBALS['admin'] = $admin;

