<?php
/**
 * Admin Dashboard
 */

$pageTitle = 'Dashboard';
require_once __DIR__ . '/includes/auth_check.php';
require_once __DIR__ . '/includes/header.php';

$db = getDB();

// Get statistics
$stats = [];

// Total Users
$stmt = $db->query("SELECT COUNT(*) as total FROM users WHERE role != 'admin'");
$stats['total_users'] = $stmt->fetch()['total'];

// Total Orders
$stmt = $db->query("SELECT COUNT(*) as total FROM orders");
$stats['total_orders'] = $stmt->fetch()['total'];

// Total Revenue
$stmt = $db->query("SELECT SUM(amount) as total FROM orders WHERE payment_status = 'completed'");
$stats['total_revenue'] = $stmt->fetch()['total'] ?? 0;

// Pending Deposits
$stmt = $db->query("SELECT COUNT(*) as total FROM deposits WHERE status = 'pending'");
$stats['pending_deposits'] = $stmt->fetch()['total'];

// Pending Withdrawals
$stmt = $db->query("SELECT COUNT(*) as total FROM withdraw_requests WHERE status = 'pending'");
$stats['pending_withdrawals'] = $stmt->fetch()['total'];

// Recent Orders
$stmt = $db->query("
    SELECT o.*, u_buyer.name as buyer_name, u_seller.name as seller_name, a.title as account_title
    FROM orders o
    JOIN users u_buyer ON o.buyer_id = u_buyer.id
    JOIN users u_seller ON o.seller_id = u_seller.id
    JOIN accounts a ON o.account_id = a.id
    ORDER BY o.created_at DESC
    LIMIT 10
");
$recentOrders = $stmt->fetchAll();
?>

<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
    <!-- Total Users -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Total Users</p>
                <p class="text-3xl font-bold text-gray-800"><?php echo number_format($stats['total_users']); ?></p>
            </div>
            <div class="bg-blue-100 rounded-full p-3">
                <i class="fas fa-users text-blue-600 text-2xl"></i>
            </div>
        </div>
    </div>
    
    <!-- Total Orders -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Total Orders</p>
                <p class="text-3xl font-bold text-gray-800"><?php echo number_format($stats['total_orders']); ?></p>
            </div>
            <div class="bg-green-100 rounded-full p-3">
                <i class="fas fa-shopping-cart text-green-600 text-2xl"></i>
            </div>
        </div>
    </div>
    
    <!-- Total Revenue -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Total Revenue</p>
                <p class="text-3xl font-bold text-gray-800">৳<?php echo number_format($stats['total_revenue'], 2); ?></p>
            </div>
            <div class="bg-yellow-100 rounded-full p-3">
                <i class="fas fa-dollar-sign text-yellow-600 text-2xl"></i>
            </div>
        </div>
    </div>
    
    <!-- Pending Actions -->
    <div class="bg-white rounded-lg shadow p-6">
        <div class="flex items-center justify-between">
            <div>
                <p class="text-gray-600 text-sm">Pending Actions</p>
                <p class="text-3xl font-bold text-gray-800"><?php echo $stats['pending_deposits'] + $stats['pending_withdrawals']; ?></p>
                <p class="text-xs text-gray-500 mt-1">
                    <?php echo $stats['pending_deposits']; ?> deposits, <?php echo $stats['pending_withdrawals']; ?> withdrawals
                </p>
            </div>
            <div class="bg-red-100 rounded-full p-3">
                <i class="fas fa-exclamation-triangle text-red-600 text-2xl"></i>
            </div>
        </div>
    </div>
</div>

<!-- Recent Orders -->
<div class="bg-white rounded-lg shadow">
    <div class="p-6 border-b">
        <h2 class="text-xl font-bold">Recent Orders</h2>
    </div>
    <div class="overflow-x-auto">
        <table class="w-full">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Order #</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Buyer</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Seller</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Amount</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Status</th>
                    <th class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase">Date</th>
                </tr>
            </thead>
            <tbody class="divide-y divide-gray-200">
                <?php foreach ($recentOrders as $order): ?>
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium"><?php echo htmlspecialchars($order['order_number']); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo htmlspecialchars($order['buyer_name']); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm"><?php echo htmlspecialchars($order['seller_name']); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm">৳<?php echo number_format($order['amount'], 2); ?></td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 py-1 text-xs rounded-full <?php 
                            echo $order['status'] === 'delivered' ? 'bg-green-100 text-green-800' : 
                                ($order['status'] === 'pending' ? 'bg-yellow-100 text-yellow-800' : 'bg-gray-100 text-gray-800');
                        ?>">
                            <?php echo ucfirst($order['status']); ?>
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        <?php echo date('M d, Y', strtotime($order['created_at'])); ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require_once __DIR__ . '/includes/footer.php'; ?>

