<?php
/**
 * Settings Management
 */

$pageTitle = 'Settings';
require_once __DIR__ . '/includes/auth_check.php';

$db = getDB();

// Handle save (BEFORE any output)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    foreach ($_POST as $key => $value) {
        if (strpos($key, 'setting_') === 0) {
            $settingKey = str_replace('setting_', '', $key);
            $stmt = $db->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = ?");
            $stmt->execute([$value, $settingKey]);
        }
    }
    
    // Handle file uploads
    if (isset($_FILES['app_logo']) && $_FILES['app_logo']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = __DIR__ . '/../storage/';
        $fileName = 'logo_' . time() . '_' . basename($_FILES['app_logo']['name']);
        move_uploaded_file($_FILES['app_logo']['tmp_name'], $uploadDir . $fileName);
        $stmt = $db->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = 'app_logo'");
        $stmt->execute([$fileName]);
    }
    
    if (isset($_FILES['splash_image']) && $_FILES['splash_image']['error'] === UPLOAD_ERR_OK) {
        $uploadDir = __DIR__ . '/../storage/';
        $fileName = 'splash_' . time() . '_' . basename($_FILES['splash_image']['name']);
        move_uploaded_file($_FILES['splash_image']['tmp_name'], $uploadDir . $fileName);
        $stmt = $db->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = 'splash_image'");
        $stmt->execute([$fileName]);
    }
    
    header('Location: settings.php?saved=1');
    exit;
}

// Now include header (after POST handling)
require_once __DIR__ . '/includes/header.php';

// Get all settings
$stmt = $db->query("SELECT setting_key, setting_value, setting_type, group_name FROM settings ORDER BY group_name, setting_key");
$settings = $stmt->fetchAll();

$groupedSettings = [];
foreach ($settings as $setting) {
    $groupedSettings[$setting['group_name']][$setting['setting_key']] = $setting;
}

$activeTab = $_GET['tab'] ?? 'general';
?>

<div class="bg-white rounded-lg shadow">
    <div class="border-b">
        <nav class="flex space-x-4 px-6">
            <button onclick="showTab('general')" class="py-4 px-2 border-b-2 <?php echo $activeTab === 'general' ? 'border-blue-500 text-blue-600' : 'border-transparent'; ?>">
                General
            </button>
            <button onclick="showTab('oauth')" class="py-4 px-2 border-b-2 <?php echo $activeTab === 'oauth' ? 'border-blue-500 text-blue-600' : 'border-transparent'; ?>">
                OAuth
            </button>
            <button onclick="showTab('payment')" class="py-4 px-2 border-b-2 <?php echo $activeTab === 'payment' ? 'border-blue-500 text-blue-600' : 'border-transparent'; ?>">
                Payment
            </button>
            <button onclick="showTab('system')" class="py-4 px-2 border-b-2 <?php echo $activeTab === 'system' ? 'border-blue-500 text-blue-600' : 'border-transparent'; ?>">
                System
            </button>
        </nav>
    </div>
    
    <?php if (isset($_GET['saved'])): ?>
        <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 m-6 rounded">
            Settings saved successfully!
        </div>
    <?php endif; ?>
    
    <form method="POST" enctype="multipart/form-data" class="p-6">
        <!-- General Settings -->
        <div id="tab-general" class="tab-content <?php echo $activeTab !== 'general' ? 'hidden' : ''; ?>">
            <h3 class="text-lg font-bold mb-4">General Settings</h3>
            
            <div class="space-y-4">
                <div>
                    <label class="block text-sm font-medium mb-2">App Name</label>
                    <input type="text" name="setting_app_name" value="<?php echo htmlspecialchars($groupedSettings['general']['app_name']['setting_value'] ?? ''); ?>" class="w-full border rounded px-3 py-2">
                </div>
                
                <div>
                    <label class="block text-sm font-medium mb-2">App Logo</label>
                    <input type="file" name="app_logo" accept="image/*" class="w-full border rounded px-3 py-2">
                    <?php if (!empty($groupedSettings['general']['app_logo']['setting_value'])): ?>
                        <p class="text-sm text-gray-500 mt-1">Current: <?php echo htmlspecialchars($groupedSettings['general']['app_logo']['setting_value']); ?></p>
                    <?php endif; ?>
                </div>
                
                <div>
                    <label class="block text-sm font-medium mb-2">Splash Image (for Flutter app)</label>
                    <input type="file" name="splash_image" accept="image/*" class="w-full border rounded px-3 py-2">
                    <?php if (!empty($groupedSettings['general']['splash_image']['setting_value'])): ?>
                        <p class="text-sm text-gray-500 mt-1">Current: <?php echo htmlspecialchars($groupedSettings['general']['splash_image']['setting_value']); ?></p>
                    <?php endif; ?>
                </div>
                
                <div>
                    <label class="block text-sm font-medium mb-2">Default Commission %</label>
                    <input type="number" step="0.01" name="setting_default_commission" value="<?php echo htmlspecialchars($groupedSettings['general']['default_commission']['setting_value'] ?? '5.00'); ?>" class="w-full border rounded px-3 py-2">
                </div>
                
                <div>
                    <label class="block text-sm font-medium mb-2">Theme Mode</label>
                    <select name="setting_theme_mode" class="w-full border rounded px-3 py-2">
                        <option value="light" <?php echo ($groupedSettings['general']['theme_mode']['setting_value'] ?? '') === 'light' ? 'selected' : ''; ?>>Light</option>
                        <option value="dark" <?php echo ($groupedSettings['general']['theme_mode']['setting_value'] ?? '') === 'dark' ? 'selected' : ''; ?>>Dark</option>
                    </select>
                </div>
            </div>
        </div>
        
        <!-- OAuth Settings -->
        <div id="tab-oauth" class="tab-content <?php echo $activeTab !== 'oauth' ? 'hidden' : ''; ?>">
            <h3 class="text-lg font-bold mb-4">Google OAuth Settings</h3>
            
            <div class="space-y-4">
                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="setting_google_oauth_enabled" value="1" <?php echo ($groupedSettings['oauth']['google_oauth_enabled']['setting_value'] ?? '0') === '1' ? 'checked' : ''; ?> class="mr-2">
                        <span>Enable Google OAuth</span>
                    </label>
                </div>
                
                <div>
                    <label class="block text-sm font-medium mb-2">Web Client ID</label>
                    <input type="text" name="setting_google_web_client_id" value="<?php echo htmlspecialchars($groupedSettings['oauth']['google_web_client_id']['setting_value'] ?? ''); ?>" class="w-full border rounded px-3 py-2">
                </div>
                
                <div>
                    <label class="block text-sm font-medium mb-2">OAuth Secret (Encrypted)</label>
                    <input type="password" name="setting_google_oauth_secret" value="<?php echo htmlspecialchars($groupedSettings['oauth']['google_oauth_secret']['setting_value'] ?? ''); ?>" class="w-full border rounded px-3 py-2">
                </div>
                
                <div>
                    <label class="block text-sm font-medium mb-2">Android Client ID</label>
                    <input type="text" name="setting_google_android_client_id" value="<?php echo htmlspecialchars($groupedSettings['oauth']['google_android_client_id']['setting_value'] ?? ''); ?>" class="w-full border rounded px-3 py-2">
                </div>
                
                <div>
                    <label class="block text-sm font-medium mb-2">iOS Client ID</label>
                    <input type="text" name="setting_google_ios_client_id" value="<?php echo htmlspecialchars($groupedSettings['oauth']['google_ios_client_id']['setting_value'] ?? ''); ?>" class="w-full border rounded px-3 py-2">
                </div>
            </div>
        </div>
        
        <!-- Payment Settings -->
        <div id="tab-payment" class="tab-content <?php echo $activeTab !== 'payment' ? 'hidden' : ''; ?>">
            <h3 class="text-lg font-bold mb-4">Payment Gateway Settings</h3>
            
            <div class="space-y-6">
                <!-- UddoktaPay -->
                <div class="border rounded p-4">
                    <h4 class="font-bold mb-3">UddoktaPay</h4>
                    <div class="space-y-3">
                        <label class="flex items-center">
                            <input type="checkbox" name="setting_uddoktapay_enabled" value="1" <?php echo ($groupedSettings['payment']['uddoktapay_enabled']['setting_value'] ?? '0') === '1' ? 'checked' : ''; ?> class="mr-2">
                            <span>Enable UddoktaPay</span>
                        </label>
                        <div>
                            <label class="block text-sm font-medium mb-1">API Key</label>
                            <input type="text" name="setting_uddoktapay_api_key" value="<?php echo htmlspecialchars($groupedSettings['payment']['uddoktapay_api_key']['setting_value'] ?? ''); ?>" class="w-full border rounded px-3 py-2">
                        </div>
                        <div>
                            <label class="block text-sm font-medium mb-1">API URL</label>
                            <input type="text" name="setting_uddoktapay_api_url" value="<?php echo htmlspecialchars($groupedSettings['payment']['uddoktapay_api_url']['setting_value'] ?? 'https://sandbox.uddoktapay.com/api/checkout'); ?>" class="w-full border rounded px-3 py-2">
                        </div>
                    </div>
                </div>
                
                <!-- SSLCommerz -->
                <div class="border rounded p-4">
                    <h4 class="font-bold mb-3">SSLCommerz</h4>
                    <div class="space-y-3">
                        <label class="flex items-center">
                            <input type="checkbox" name="setting_sslcommerz_enabled" value="1" <?php echo ($groupedSettings['payment']['sslcommerz_enabled']['setting_value'] ?? '0') === '1' ? 'checked' : ''; ?> class="mr-2">
                            <span>Enable SSLCommerz</span>
                        </label>
                        <div>
                            <label class="block text-sm font-medium mb-1">Store ID</label>
                            <input type="text" name="setting_sslcommerz_store_id" value="<?php echo htmlspecialchars($groupedSettings['payment']['sslcommerz_store_id']['setting_value'] ?? ''); ?>" class="w-full border rounded px-3 py-2">
                        </div>
                        <div>
                            <label class="block text-sm font-medium mb-1">Store Password</label>
                            <input type="password" name="setting_sslcommerz_store_password" value="<?php echo htmlspecialchars($groupedSettings['payment']['sslcommerz_store_password']['setting_value'] ?? ''); ?>" class="w-full border rounded px-3 py-2">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- System Settings -->
        <div id="tab-system" class="tab-content <?php echo $activeTab !== 'system' ? 'hidden' : ''; ?>">
            <h3 class="text-lg font-bold mb-4">System Settings</h3>
            
            <div class="space-y-4">
                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="setting_maintenance_mode" value="1" <?php echo ($groupedSettings['system']['maintenance_mode']['setting_value'] ?? '0') === '1' ? 'checked' : ''; ?> class="mr-2">
                        <span>Maintenance Mode</span>
                    </label>
                </div>
                
                <div>
                    <label class="block text-sm font-medium mb-2">App Version</label>
                    <input type="text" name="setting_app_version" value="<?php echo htmlspecialchars($groupedSettings['system']['app_version']['setting_value'] ?? '1.0.0'); ?>" class="w-full border rounded px-3 py-2">
                </div>
                
                <div>
                    <label class="flex items-center">
                        <input type="checkbox" name="setting_force_update" value="1" <?php echo ($groupedSettings['system']['force_update']['setting_value'] ?? '0') === '1' ? 'checked' : ''; ?> class="mr-2">
                        <span>Force Update</span>
                    </label>
                </div>
            </div>
        </div>
        
        <div class="mt-6 flex justify-end">
            <button type="submit" class="bg-blue-500 hover:bg-blue-700 text-white font-bold py-2 px-4 rounded">
                Save Settings
            </button>
        </div>
    </form>
</div>

<script>
function showTab(tab) {
    document.querySelectorAll('.tab-content').forEach(el => el.classList.add('hidden'));
    document.getElementById('tab-' + tab).classList.remove('hidden');
    
    document.querySelectorAll('nav button').forEach(btn => {
        btn.classList.remove('border-blue-500', 'text-blue-600');
        btn.classList.add('border-transparent');
    });
    
    event.target.classList.add('border-blue-500', 'text-blue-600');
    event.target.classList.remove('border-transparent');
}
</script>

<?php require_once __DIR__ . '/includes/footer.php'; ?>

