<?php
/**
 * Announcements API
 * Broadcast notifications to all users
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/middleware.php';
require_once __DIR__ . '/../database.php';

$db = getDB();
$method = $_SERVER['REQUEST_METHOD'];

// Get announcements (public)
if ($method === 'GET') {
    $limit = intval($_GET['limit'] ?? 5);
    
    $stmt = $db->prepare("
        SELECT * FROM notifications 
        WHERE user_id IS NULL 
        ORDER BY created_at DESC 
        LIMIT ?
    ");
    $stmt->execute([$limit]);
    $announcements = $stmt->fetchAll();
    
    echo json_encode(['success' => true, 'data' => $announcements]);
    exit;
}

// Create announcement (Admin only)
if ($method === 'POST') {
    $admin = requireAdmin();
    $input = json_decode(file_get_contents('php://input'), true);
    
    $title = trim($input['title'] ?? '');
    $message = trim($input['message'] ?? '');
    $type = $input['type'] ?? 'info';
    
    if (empty($title) || empty($message)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Title and message are required']);
        exit;
    }
    
    // Create broadcast notification (user_id = NULL)
    $stmt = $db->prepare("
        INSERT INTO notifications (user_id, title, message, type)
        VALUES (NULL, ?, ?, ?)
    ");
    $stmt->execute([$title, $message, $type]);
    
    $notificationId = $db->lastInsertId();
    
    echo json_encode([
        'success' => true,
        'message' => 'Announcement created',
        'data' => ['id' => $notificationId]
    ]);
    exit;
}

http_response_code(405);
echo json_encode(['success' => false, 'message' => 'Method not allowed']);

