<?php
/**
 * Notifications API
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/middleware.php';
require_once __DIR__ . '/../database.php';

$db = getDB();
$method = $_SERVER['REQUEST_METHOD'];

// Get notifications
if ($method === 'GET') {
    $user = requireAuth();
    $page = $_GET['page'] ?? 1;
    $limit = 20;
    $offset = ($page - 1) * $limit;
    
    // Get user-specific and broadcast notifications
    $stmt = $db->prepare("
        SELECT * FROM notifications 
        WHERE user_id = ? OR user_id IS NULL
        ORDER BY created_at DESC 
        LIMIT ? OFFSET ?
    ");
    $stmt->execute([$user['id'], $limit, $offset]);
    $notifications = $stmt->fetchAll();
    
    // Get unread count
    $stmt = $db->prepare("SELECT COUNT(*) as total FROM notifications WHERE (user_id = ? OR user_id IS NULL) AND is_read = 0");
    $stmt->execute([$user['id']]);
    $unreadCount = $stmt->fetch()['total'];
    
    echo json_encode([
        'success' => true,
        'data' => [
            'notifications' => $notifications,
            'unread_count' => (int)$unreadCount
        ]
    ]);
    exit;
}

// Mark as read
if ($method === 'PUT' && isset($_GET['id'])) {
    $user = requireAuth();
    $notificationId = $_GET['id'];
    
    $stmt = $db->prepare("UPDATE notifications SET is_read = 1 WHERE id = ? AND (user_id = ? OR user_id IS NULL)");
    $stmt->execute([$notificationId, $user['id']]);
    
    echo json_encode(['success' => true, 'message' => 'Notification marked as read']);
    exit;
}

// Mark all as read
if ($method === 'PUT' && isset($_GET['action']) && $_GET['action'] === 'read_all') {
    $user = requireAuth();
    
    $stmt = $db->prepare("UPDATE notifications SET is_read = 1 WHERE (user_id = ? OR user_id IS NULL) AND is_read = 0");
    $stmt->execute([$user['id']]);
    
    echo json_encode(['success' => true, 'message' => 'All notifications marked as read']);
    exit;
}

http_response_code(405);
echo json_encode(['success' => false, 'message' => 'Method not allowed']);

