<?php
/**
 * Reviews API
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/middleware.php';
require_once __DIR__ . '/../database.php';

$db = getDB();
$method = $_SERVER['REQUEST_METHOD'];

// Get reviews for a seller
if ($method === 'GET') {
    $sellerId = $_GET['seller_id'] ?? null;
    
    if (!$sellerId) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'seller_id is required']);
        exit;
    }
    
    $stmt = $db->prepare("
        SELECT r.*, u.name as buyer_name, u.avatar as buyer_avatar, o.order_number
        FROM reviews r
        JOIN users u ON r.buyer_id = u.id
        JOIN orders o ON r.order_id = o.id
        WHERE r.seller_id = ?
        ORDER BY r.created_at DESC
    ");
    $stmt->execute([$sellerId]);
    $reviews = $stmt->fetchAll();
    
    // Calculate average rating
    $stmt = $db->prepare("SELECT AVG(rating) as avg_rating, COUNT(*) as total_reviews FROM reviews WHERE seller_id = ?");
    $stmt->execute([$sellerId]);
    $stats = $stmt->fetch();
    
    echo json_encode([
        'success' => true,
        'data' => [
            'reviews' => $reviews,
            'average_rating' => (float)($stats['avg_rating'] ?? 0),
            'total_reviews' => (int)($stats['total_reviews'] ?? 0)
        ]
    ]);
    exit;
}

http_response_code(405);
echo json_encode(['success' => false, 'message' => 'Method not allowed']);

