<?php
/**
 * Search API
 * Universal search across accounts, users, orders
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/middleware.php';
require_once __DIR__ . '/../database.php';

$db = getDB();
$user = requireAuth();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $query = trim($_GET['q'] ?? '');
    $type = $_GET['type'] ?? 'all'; // all, accounts, sellers
    
    if (empty($query)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Search query is required']);
        exit;
    }
    
    $results = [];
    $searchTerm = "%{$query}%";
    
    // Search accounts
    if ($type === 'all' || $type === 'accounts') {
        $stmt = $db->prepare("
            SELECT a.id, a.title, a.description, a.price, a.stock,
                   st.name as social_type_name, u.name as seller_name
            FROM accounts a
            JOIN social_media_types st ON a.social_type_id = st.id
            JOIN users u ON a.seller_id = u.id
            WHERE a.is_active = 1 AND a.stock > 0
            AND (a.title LIKE ? OR a.description LIKE ? OR st.name LIKE ?)
            ORDER BY a.created_at DESC
            LIMIT 20
        ");
        $stmt->execute([$searchTerm, $searchTerm, $searchTerm]);
        $results['accounts'] = $stmt->fetchAll();
    }
    
    // Search sellers
    if ($type === 'all' || $type === 'sellers') {
        $stmt = $db->prepare("
            SELECT u.id, u.name, u.avatar, u.is_verified,
                   (SELECT AVG(rating) FROM reviews r WHERE r.seller_id = u.id) as rating,
                   (SELECT COUNT(*) FROM reviews r WHERE r.seller_id = u.id) as review_count,
                   (SELECT COUNT(*) FROM accounts a WHERE a.seller_id = u.id AND a.is_active = 1) as listings_count
            FROM users u
            WHERE u.role = 'seller' AND u.is_blocked = 0
            AND u.name LIKE ?
            ORDER BY u.created_at DESC
            LIMIT 20
        ");
        $stmt->execute([$searchTerm]);
        $results['sellers'] = $stmt->fetchAll();
    }
    
    echo json_encode(['success' => true, 'data' => $results]);
    exit;
}

http_response_code(405);
echo json_encode(['success' => false, 'message' => 'Method not allowed']);

