<?php
/**
 * Settings API
 * Get app settings for Flutter app
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/../config.php';
require_once __DIR__ . '/../database.php';

$db = getDB();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $stmt = $db->query("SELECT setting_key, setting_value, setting_type, group_name FROM settings");
    $settings = $stmt->fetchAll();
    
    $result = [];
    foreach ($settings as $setting) {
        $value = $setting['setting_value'];
        
        // Convert based on type
        if ($setting['setting_type'] === 'boolean') {
            $value = (bool)$value;
        } elseif ($setting['setting_type'] === 'number') {
            $value = is_numeric($value) ? (float)$value : 0;
        } elseif ($setting['setting_type'] === 'json') {
            $value = json_decode($value, true);
        }
        
        $result[$setting['group_name']][$setting['setting_key']] = $value;
    }
    
    // Add base URLs
    $result['app'] = [
        'base_url' => BASE_URL,
        'api_url' => API_URL,
        'admin_url' => ADMIN_URL
    ];
    
    echo json_encode([
        'success' => true,
        'data' => $result
    ]);
    exit;
}

http_response_code(405);
echo json_encode(['success' => false, 'message' => 'Method not allowed']);

