<?php
/**
 * Social Media Types API
 * Get list of available social media platforms
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/../database.php';

$db = getDB();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $stmt = $db->query("
        SELECT id, name, slug, commission_percent, min_price, max_price, icon,
               (SELECT COUNT(*) FROM accounts a WHERE a.social_type_id = st.id AND a.is_active = 1) as available_accounts
        FROM social_media_types st
        WHERE is_active = 1
        ORDER BY name ASC
    ");
    $types = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'data' => $types
    ]);
    exit;
}

http_response_code(405);
echo json_encode(['success' => false, 'message' => 'Method not allowed']);

