<?php
/**
 * Statistics API
 * Get dashboard statistics
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/middleware.php';
require_once __DIR__ . '/../database.php';

$db = getDB();
$user = requireAuth();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $type = $_GET['type'] ?? 'user'; // user, seller, admin
    
    $stats = [];
    
    if ($type === 'user' || $user['role'] === 'buyer') {
        // Buyer stats
        $stmt = $db->prepare("SELECT COUNT(*) as total FROM orders WHERE buyer_id = ?");
        $stmt->execute([$user['id']]);
        $stats['total_orders'] = (int)$stmt->fetch()['total'];
        
        $stmt = $db->prepare("SELECT SUM(amount) as total FROM orders WHERE buyer_id = ? AND payment_status = 'completed'");
        $stmt->execute([$user['id']]);
        $stats['total_spent'] = (float)($stmt->fetch()['total'] ?? 0);
    }
    
    if ($type === 'seller' || $user['role'] === 'seller') {
        // Seller stats
        $stmt = $db->prepare("SELECT COUNT(*) as total FROM accounts WHERE seller_id = ? AND is_active = 1");
        $stmt->execute([$user['id']]);
        $stats['active_listings'] = (int)$stmt->fetch()['total'];
        
        $stmt = $db->prepare("SELECT COUNT(*) as total FROM orders WHERE seller_id = ?");
        $stmt->execute([$user['id']]);
        $stats['total_sales'] = (int)$stmt->fetch()['total'];
        
        $stmt = $db->prepare("SELECT SUM(seller_earnings) as total FROM orders WHERE seller_id = ? AND status = 'delivered'");
        $stmt->execute([$user['id']]);
        $stats['total_earnings'] = (float)($stmt->fetch()['total'] ?? 0);
        
        $stmt = $db->prepare("SELECT AVG(rating) as avg FROM reviews WHERE seller_id = ?");
        $stmt->execute([$user['id']]);
        $stats['average_rating'] = (float)($stmt->fetch()['avg'] ?? 0);
    }
    
    if ($user['role'] === 'admin') {
        // Admin stats
        $stmt = $db->query("SELECT COUNT(*) as total FROM users WHERE role != 'admin'");
        $stats['total_users'] = (int)$stmt->fetch()['total'];
        
        $stmt = $db->query("SELECT COUNT(*) as total FROM orders");
        $stats['total_orders'] = (int)$stmt->fetch()['total'];
        
        $stmt = $db->query("SELECT SUM(amount) as total FROM orders WHERE payment_status = 'completed'");
        $stats['total_revenue'] = (float)($stmt->fetch()['total'] ?? 0);
        
        $stmt = $db->query("SELECT COUNT(*) as total FROM deposits WHERE status = 'pending'");
        $stats['pending_deposits'] = (int)$stmt->fetch()['total'];
        
        $stmt = $db->query("SELECT COUNT(*) as total FROM withdraw_requests WHERE status = 'pending'");
        $stats['pending_withdrawals'] = (int)$stmt->fetch()['total'];
    }
    
    echo json_encode(['success' => true, 'data' => $stats]);
    exit;
}

http_response_code(405);
echo json_encode(['success' => false, 'message' => 'Method not allowed']);

