<?php
/**
 * Users API
 * Profile management, role switch
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/middleware.php';
require_once __DIR__ . '/../database.php';

$db = getDB();
$method = $_SERVER['REQUEST_METHOD'];

// Get current user profile
if ($method === 'GET' && !isset($_GET['id'])) {
    $user = requireAuth();
    
    $stmt = $db->prepare("
        SELECT id, name, email, role, avatar, wallet_balance, is_verified, 
               created_at, kyc_status
        FROM users WHERE id = ?
    ");
    $stmt->execute([$user['id']]);
    $profile = $stmt->fetch();
    
    echo json_encode(['success' => true, 'data' => $profile]);
    exit;
}

// Update profile
if ($method === 'PUT') {
    $user = requireAuth();
    $input = json_decode(file_get_contents('php://input'), true);
    
    $name = trim($input['name'] ?? '');
    $avatar = $input['avatar'] ?? null;
    
    if (empty($name)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Name is required']);
        exit;
    }
    
    $stmt = $db->prepare("UPDATE users SET name = ?, avatar = ? WHERE id = ?");
    $stmt->execute([$name, $avatar, $user['id']]);
    
    $stmt = $db->prepare("SELECT id, name, email, role, avatar, wallet_balance, is_verified FROM users WHERE id = ?");
    $stmt->execute([$user['id']]);
    $updated = $stmt->fetch();
    
    echo json_encode(['success' => true, 'message' => 'Profile updated', 'data' => $updated]);
    exit;
}

// Switch role (Buyer ↔ Seller)
if ($method === 'POST' && isset($_GET['action']) && $_GET['action'] === 'switch_role') {
    $user = requireAuth();
    
    $newRole = $user['role'] === 'buyer' ? 'seller' : 'buyer';
    
    $stmt = $db->prepare("UPDATE users SET role = ? WHERE id = ?");
    $stmt->execute([$newRole, $user['id']]);
    
    echo json_encode([
        'success' => true,
        'message' => 'Role switched successfully',
        'data' => ['role' => $newRole]
    ]);
    exit;
}

http_response_code(405);
echo json_encode(['success' => false, 'message' => 'Method not allowed']);

