<?php
/**
 * Withdraw Gateways Management API
 * Admin only - for managing withdraw gateways
 */

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(200);
    exit;
}

require_once __DIR__ . '/middleware.php';
require_once __DIR__ . '/../database.php';

$db = getDB();
$method = $_SERVER['REQUEST_METHOD'];

// Admin only
$admin = requireAdmin();

// List gateways
if ($method === 'GET') {
    $stmt = $db->query("SELECT * FROM withdraw_gateways ORDER BY name ASC");
    $gateways = $stmt->fetchAll();
    
    echo json_encode(['success' => true, 'data' => $gateways]);
    exit;
}

// Create gateway
if ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    
    $name = trim($input['name'] ?? '');
    $type = trim($input['type'] ?? '');
    $logo = $input['logo'] ?? null;
    $minAmount = floatval($input['min_amount'] ?? 0);
    $maxAmount = floatval($input['max_amount'] ?? 10000);
    $instruction = $input['instruction'] ?? '';
    $isActive = isset($input['is_active']) ? ($input['is_active'] ? 1 : 0) : 1;
    
    if (empty($name) || empty($type)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Name and type are required']);
        exit;
    }
    
    $stmt = $db->prepare("
        INSERT INTO withdraw_gateways (name, type, logo, min_amount, max_amount, instruction, is_active)
        VALUES (?, ?, ?, ?, ?, ?, ?)
    ");
    $stmt->execute([$name, $type, $logo, $minAmount, $maxAmount, $instruction, $isActive]);
    
    $gatewayId = $db->lastInsertId();
    echo json_encode(['success' => true, 'message' => 'Gateway created', 'data' => ['id' => $gatewayId]]);
    exit;
}

// Update gateway
if ($method === 'PUT' && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    $input = json_decode(file_get_contents('php://input'), true);
    
    $updates = [];
    $params = [];
    
    if (isset($input['name'])) {
        $updates[] = "name = ?";
        $params[] = trim($input['name']);
    }
    if (isset($input['type'])) {
        $updates[] = "type = ?";
        $params[] = trim($input['type']);
    }
    if (isset($input['logo'])) {
        $updates[] = "logo = ?";
        $params[] = $input['logo'];
    }
    if (isset($input['min_amount'])) {
        $updates[] = "min_amount = ?";
        $params[] = floatval($input['min_amount']);
    }
    if (isset($input['max_amount'])) {
        $updates[] = "max_amount = ?";
        $params[] = floatval($input['max_amount']);
    }
    if (isset($input['instruction'])) {
        $updates[] = "instruction = ?";
        $params[] = $input['instruction'];
    }
    if (isset($input['is_active'])) {
        $updates[] = "is_active = ?";
        $params[] = $input['is_active'] ? 1 : 0;
    }
    
    if (empty($updates)) {
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'No fields to update']);
        exit;
    }
    
    $params[] = $id;
    $query = "UPDATE withdraw_gateways SET " . implode(', ', $updates) . " WHERE id = ?";
    $stmt = $db->prepare($query);
    $stmt->execute($params);
    
    echo json_encode(['success' => true, 'message' => 'Gateway updated']);
    exit;
}

// Delete gateway
if ($method === 'DELETE' && isset($_GET['id'])) {
    $id = intval($_GET['id']);
    
    $stmt = $db->prepare("DELETE FROM withdraw_gateways WHERE id = ?");
    $stmt->execute([$id]);
    
    echo json_encode(['success' => true, 'message' => 'Gateway deleted']);
    exit;
}

http_response_code(405);
echo json_encode(['success' => false, 'message' => 'Method not allowed']);

